/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.justarod.mixin;

import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_5132;
import net.minecraft.class_8710;
import org.cneko.justarod.JRAttributes;
import org.cneko.justarod.entity.Powerable;
import org.cneko.justarod.packet.PowerSyncPayload;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
implements Powerable {
    @Unique
    private double power = 0.0;
    @Unique
    private short slowTick = (short)10;

    @Override
    public double getPower() {
        return this.power;
    }

    @Override
    public void setPower(double power) {
        this.power = power;
    }

    @Override
    public boolean canPowerUp() {
        class_1657 player = (class_1657)this;
        return player.method_7344().method_7586() >= 3;
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    public void readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        PlayerMixin playerMixin = this;
        if (!(playerMixin instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)playerMixin;
        this.power = this.readPowerFromNbt(nbt);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="HEAD")})
    public void writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        PlayerMixin playerMixin = this;
        if (!(playerMixin instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)playerMixin;
        this.writePowerToNbt(nbt);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        Powerable.tickPower(player);
        short s = this.slowTick;
        this.slowTick = (short)(s + 1);
        if (s >= 10 && player instanceof class_3222) {
            class_3222 sp = (class_3222)player;
            ServerPlayNetworking.send((class_3222)sp, (class_8710)new PowerSyncPayload(this.getPower()));
        }
    }

    @Inject(method={"createPlayerAttributes"}, at={@At(value="RETURN")})
    private static void createPlayerAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        ((class_5132.class_5133)cir.getReturnValue()).method_26867(JRAttributes.Companion.getPLAYER_LUBRICATING()).method_26867(JRAttributes.Companion.getGENERIC_MAX_POWER());
    }
}

