/*
 * Decompiled with CFR 0.152.
 */
package org.cneko.justarod.client.screen;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_8710;
import org.cneko.justarod.packet.FullHeatPayload;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000fJ'\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015J7\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u000fJ\u000f\u0010\u001c\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ1\u0010\u001e\u001a\u00020\u000b2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001e\u0010\rR\u0016\u0010\u001f\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010 R\u0016\u0010\"\u001a\u00020\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0016\u0010(\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010 R\u0014\u0010)\u001a\u00020\t8\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b)\u0010 R\u0014\u0010*\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010 R\u0014\u0010+\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010 R\u0016\u0010,\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010 R\u0016\u0010-\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010 R\u0016\u0010/\u001a\u00020.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100\u00a8\u00062"}, d2={"Lorg/cneko/justarod/client/screen/FrictionScreen;", "Lnet/minecraft/class_437;", "<init>", "()V", "Lnet/minecraft/class_332;", "context", "", "mouseX", "mouseY", "", "delta", "", "render", "(Lnet/minecraft/class_332;IIF)V", "updateHeat", "(F)V", "updateParticles", "", "button", "", "mouseClicked", "(DDI)Z", "mouseReleased", "deltaX", "deltaY", "mouseDragged", "(DDIDD)Z", "updateSliderPosition", "shouldPause", "()Z", "renderBackground", "heat", "F", "sliderPosition", "sliderDragging", "Z", "", "Lorg/cneko/justarod/client/screen/FrictionScreen$Particle;", "particles", "Ljava/util/List;", "lastSliderPosition", "maxHeat", "heatWarningThreshold", "shakeThreshold", "shakeOffsetX", "shakeOffsetY", "", "lastShakeTime", "J", "Particle", "JustARod"})
public final class FrictionScreen
extends class_437 {
    private float heat;
    private float sliderPosition = 0.5f;
    private boolean sliderDragging;
    @NotNull
    private final List<Particle> particles = new ArrayList();
    private float lastSliderPosition = 0.5f;
    private final float maxHeat;
    private final float heatWarningThreshold = 0.7f * this.maxHeat;
    private final float shakeThreshold = 0.8f * this.maxHeat;
    private float shakeOffsetX;
    private float shakeOffsetY;
    private long lastShakeTime;

    public FrictionScreen() {
        super((class_2561)class_2561.method_43473());
        this.maxHeat = 3000.0f;
    }

    public void method_25394(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
        float f;
        float progress;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.updateHeat(delta);
        this.updateParticles(delta);
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        if (this.heat > this.shakeThreshold) {
            float shakeIntensity = (this.heat - this.shakeThreshold) / (this.maxHeat - this.shakeThreshold);
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastShakeTime > 50L) {
                this.shakeOffsetX = Random.Default.nextFloat() * 10.0f * shakeIntensity - 5.0f * shakeIntensity;
                this.shakeOffsetY = Random.Default.nextFloat() * 10.0f * shakeIntensity - 5.0f * shakeIntensity;
                this.lastShakeTime = currentTime;
            }
            matrices.method_46416(this.shakeOffsetX, this.shakeOffsetY, 0.0f);
        } else {
            this.shakeOffsetX = 0.0f;
            this.shakeOffsetY = 0.0f;
        }
        int width = this.field_22789;
        int height = this.field_22790;
        float barWidth = (float)width * 0.8f;
        float barHeight = 20.0f;
        float barX = ((float)width - barWidth) / (float)2;
        float barY = (float)height * 0.3f;
        context.method_25294((int)barX, (int)barY, (int)(barX + barWidth), (int)(barY + barHeight), -13421773);
        float heatWidth = barWidth * (this.heat / this.maxHeat);
        int n = (int)heatWidth;
        for (int i = 0; i < n; ++i) {
            progress = (float)i / barWidth;
            int red = 255;
            int green = (int)((float)255 * progress);
            int blue = (int)((float)255 * progress);
            int color = 0xFF000000 | red << 16 | green << 8 | blue;
            context.method_25294((int)(barX + (float)i), (int)barY, (int)(barX + (float)i + 1.0f), (int)(barY + barHeight), color);
        }
        float baseSliderWidth = 100.0f;
        if (this.heat > this.maxHeat * 0.5f) {
            progress = (this.heat - 0.5f * this.maxHeat) / (0.5f * this.maxHeat);
            f = baseSliderWidth * (1.0f + progress);
        } else {
            f = baseSliderWidth;
        }
        float sliderWidth = f;
        float sliderHeight = 20.0f;
        float sliderX = ((float)width - sliderWidth) / (float)2;
        float sliderY = (float)height * 0.5f;
        float sliderThumbX = sliderX + this.sliderPosition * sliderWidth;
        context.method_25294((int)sliderX, (int)(sliderY + sliderHeight / (float)2 - (float)2), (int)(sliderX + sliderWidth), (int)(sliderY + sliderHeight / (float)2 + (float)2), -5592406);
        class_1799 stack = new class_1799((class_1935)class_1802.field_8407);
        int itemX = (int)(sliderThumbX - (float)8);
        int itemY = (int)(sliderY - (float)4);
        context.method_51427(stack, itemX, itemY);
        for (Particle particle : this.particles) {
            context.method_25294((int)particle.getX(), (int)particle.getY(), (int)(particle.getX() + particle.getSize()), (int)(particle.getY() + particle.getSize()), -1);
        }
        matrices.method_22909();
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private final void updateHeat(float delta) {
        if (this.heat > 0.95f * this.maxHeat) {
            ClientPlayNetworking.send((class_8710)new FullHeatPayload("full"));
            class_310.method_1551().method_1507(null);
        }
        float positionChange = Math.abs(this.sliderPosition - this.lastSliderPosition);
        if (this.sliderDragging && positionChange > 0.001f) {
            float friction = Math.abs(this.sliderPosition - 0.5f) * (float)2 + positionChange * (float)10;
            this.heat += friction * delta * 5.0f;
        }
        this.lastSliderPosition = this.sliderPosition;
        this.heat = Math.max(0.0f, Math.min(this.maxHeat, this.heat));
        float coolingRate = this.heat > this.heatWarningThreshold ? 5.0E-4f * this.maxHeat : 2.0E-4f * this.maxHeat;
        this.heat = Math.max(0.0f, this.heat - coolingRate * delta);
    }

    private final void updateParticles(float delta) {
        if (this.heat > this.heatWarningThreshold) {
            float spawnChance = (this.heat - this.heatWarningThreshold) / (this.maxHeat - this.heatWarningThreshold) * delta * (float)200;
            int particlesToAdd = (int)(spawnChance * (float)3);
            for (int i = 0; i < particlesToAdd; ++i) {
                int it = i;
                boolean bl = false;
                float barWidth = (float)this.field_22789 * 0.8f;
                float barX = ((float)this.field_22789 - barWidth) / (float)2;
                float barY = (float)this.field_22790 * 0.3f;
                boolean isRising = Random.Default.nextBoolean();
                float baseSpeedY = isRising ? -50.0f : 30.0f;
                this.particles.add(new Particle(barX + barWidth * (this.heat / this.maxHeat), barY + Random.Default.nextFloat() * 20.0f, 1.0f + Random.Default.nextFloat() * 4.0f, 50.0f + Random.Default.nextFloat() * 150.0f, baseSpeedY + Random.Default.nextFloat() * (isRising ? 40.0f : 30.0f), 0.5f + Random.Default.nextFloat() * 3.0f, isRising));
            }
        }
        Iterator<Particle> iterator = this.particles.iterator();
        while (iterator.hasNext()) {
            Particle particle = iterator.next();
            particle.setX(particle.getX() + particle.getSpeedX() * delta);
            particle.setY(particle.getY() + particle.getSpeedY() * delta);
            particle.setLife(particle.getLife() - delta);
            if (particle.isRising()) {
                particle.setSpeedY(particle.getSpeedY() - 10.0f * delta);
            } else {
                particle.setSpeedY(particle.getSpeedY() + 10.0f * delta);
            }
            if (!(particle.getLife() <= 0.0f || particle.getX() > (float)this.field_22789 || particle.getY() > (float)this.field_22790) && !(particle.getY() < 0.0f)) continue;
            iterator.remove();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        float sliderWidth = 100.0f;
        float sliderHeight = 20.0f;
        float sliderX = ((float)this.field_22789 - sliderWidth) / (float)2;
        float sliderY = (float)this.field_22790 * 0.5f;
        if (mouseX >= (double)sliderX && mouseX <= (double)(sliderX + sliderWidth) && mouseY >= (double)sliderY && mouseY <= (double)(sliderY + sliderHeight)) {
            this.sliderDragging = true;
            this.updateSliderPosition((float)mouseX);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.sliderDragging = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.sliderDragging) {
            this.updateSliderPosition((float)mouseX);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private final void updateSliderPosition(float mouseX) {
        float sliderWidth = 100.0f;
        float sliderX = ((float)this.field_22789 - sliderWidth) / (float)2;
        this.sliderPosition = RangesKt.coerceIn((float)((mouseX - sliderX) / sliderWidth), (float)0.0f, (float)1.0f);
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(@Nullable class_332 context, int mouseX, int mouseY, float delta) {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0082\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0010\u0010\u0010\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u000eJ\u0010\u0010\u0012\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u000eJ\u0010\u0010\u0013\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u000eJ\u0010\u0010\u0014\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015JV\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u0019\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010 R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u000e\"\u0004\b#\u0010$R\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010!\u001a\u0004\b%\u0010\u000e\"\u0004\b&\u0010$R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b'\u0010\u000eR\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010!\u001a\u0004\b(\u0010\u000eR\"\u0010\u0007\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010!\u001a\u0004\b)\u0010\u000e\"\u0004\b*\u0010$R\"\u0010\b\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010!\u001a\u0004\b+\u0010\u000e\"\u0004\b,\u0010$R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010-\u001a\u0004\b\n\u0010\u0015\u00a8\u0006."}, d2={"Lorg/cneko/justarod/client/screen/FrictionScreen$Particle;", "", "", "x", "y", "size", "speedX", "speedY", "life", "", "isRising", "<init>", "(FFFFFFZ)V", "component1", "()F", "component2", "component3", "component4", "component5", "component6", "component7", "()Z", "copy", "(FFFFFFZ)Lorg/cneko/justarod/client/screen/FrictionScreen$Particle;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "F", "getX", "setX", "(F)V", "getY", "setY", "getSize", "getSpeedX", "getSpeedY", "setSpeedY", "getLife", "setLife", "Z", "JustARod"})
    private static final class Particle {
        private float x;
        private float y;
        private final float size;
        private final float speedX;
        private float speedY;
        private float life;
        private final boolean isRising;

        public Particle(float x, float y, float size, float speedX, float speedY, float life, boolean isRising) {
            this.x = x;
            this.y = y;
            this.size = size;
            this.speedX = speedX;
            this.speedY = speedY;
            this.life = life;
            this.isRising = isRising;
        }

        public final float getX() {
            return this.x;
        }

        public final void setX(float f) {
            this.x = f;
        }

        public final float getY() {
            return this.y;
        }

        public final void setY(float f) {
            this.y = f;
        }

        public final float getSize() {
            return this.size;
        }

        public final float getSpeedX() {
            return this.speedX;
        }

        public final float getSpeedY() {
            return this.speedY;
        }

        public final void setSpeedY(float f) {
            this.speedY = f;
        }

        public final float getLife() {
            return this.life;
        }

        public final void setLife(float f) {
            this.life = f;
        }

        public final boolean isRising() {
            return this.isRising;
        }

        public final float component1() {
            return this.x;
        }

        public final float component2() {
            return this.y;
        }

        public final float component3() {
            return this.size;
        }

        public final float component4() {
            return this.speedX;
        }

        public final float component5() {
            return this.speedY;
        }

        public final float component6() {
            return this.life;
        }

        public final boolean component7() {
            return this.isRising;
        }

        @NotNull
        public final Particle copy(float x, float y, float size, float speedX, float speedY, float life, boolean isRising) {
            return new Particle(x, y, size, speedX, speedY, life, isRising);
        }

        public static /* synthetic */ Particle copy$default(Particle particle, float f, float f2, float f3, float f4, float f5, float f6, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                f = particle.x;
            }
            if ((n & 2) != 0) {
                f2 = particle.y;
            }
            if ((n & 4) != 0) {
                f3 = particle.size;
            }
            if ((n & 8) != 0) {
                f4 = particle.speedX;
            }
            if ((n & 0x10) != 0) {
                f5 = particle.speedY;
            }
            if ((n & 0x20) != 0) {
                f6 = particle.life;
            }
            if ((n & 0x40) != 0) {
                bl = particle.isRising;
            }
            return particle.copy(f, f2, f3, f4, f5, f6, bl);
        }

        @NotNull
        public String toString() {
            return "Particle(x=" + this.x + ", y=" + this.y + ", size=" + this.size + ", speedX=" + this.speedX + ", speedY=" + this.speedY + ", life=" + this.life + ", isRising=" + this.isRising + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.x);
            result = result * 31 + Float.hashCode(this.y);
            result = result * 31 + Float.hashCode(this.size);
            result = result * 31 + Float.hashCode(this.speedX);
            result = result * 31 + Float.hashCode(this.speedY);
            result = result * 31 + Float.hashCode(this.life);
            result = result * 31 + Boolean.hashCode(this.isRising);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Particle)) {
                return false;
            }
            Particle particle = (Particle)other;
            if (Float.compare(this.x, particle.x) != 0) {
                return false;
            }
            if (Float.compare(this.y, particle.y) != 0) {
                return false;
            }
            if (Float.compare(this.size, particle.size) != 0) {
                return false;
            }
            if (Float.compare(this.speedX, particle.speedX) != 0) {
                return false;
            }
            if (Float.compare(this.speedY, particle.speedY) != 0) {
                return false;
            }
            if (Float.compare(this.life, particle.life) != 0) {
                return false;
            }
            return this.isRising == particle.isRising;
        }
    }
}

